﻿<?php
  /**
   * Transactions
   *
   * @package Digital Downloads Pro
   * @author wojoscripts.com
   * @copyright 2010
   * @version $Id: transactions.php, v2.00 2011-07-10 10:12:05 gewa Exp $
   */
  if (!defined("_VALID_PHP"))
      die('. دسترسی مستقیم به این محل مجاز نمی باشد');
?>
<?php switch($core->action): case "salesyear": ?>
<h1><img src="images/trans-lrg.png" alt="" />مشـاهـده گـزارش فـروش</h1>
<p class="info">. در اینجا شما می توانید گـزارش فـروش خود را مشاهده نمائید</p>
<?php $reports = $item->yearlyStats();?>
<?php $row = $item->getYearlySummary();?>
<?php if($reports != 0):?>
<script language="javascript" type="text/javascript" src="../assets/jquery.jqplot.min.js"></script> 
<script language="javascript" type="text/javascript" src="../assets/jqplot.barRenderer.min.js"></script> 
<script language="javascript" type="text/javascript" src="../assets/jqplot.categoryAxisRenderer.min.js"></script> 
<script type="text/javascript" src="../assets/jqplot.pointLabels.min.js"></script> 
<!--[if lt IE 9]><script language="javascript" type="text/javascript" src="../assets/excanvas.min.js"></script><![endif]--> 
<script type="text/javascript">
  $(document).ready(function(){
    var s1 = [
	<?php
		$res = '';
		foreach($reports as $report) {
			if(strlen($res) > 0) {
				$res .= ",";
			}
			$res .= $report['total'];
		}
		echo $res;
		?>
	];
    var s2 = [
	<?php
		$res2 = '';
		foreach($reports as $report) {
			if(strlen($res2) > 0) {
				$res2 .= ",";
			}
			$res2 .= $report['totalprice'];
		}
		echo $res2;
		?>
	];
    var ticks = [
	<?php
		$res3 = '';
		foreach($reports as $rep) {
			if(strlen($res3) > 0) {
				$res3 .= "','";
			}
			$res3 .= date("M", mktime(0, 0, 0, $rep['month'], 10));
		}
		?>
		'<?php print $res3;?>'
	];
    <?php unset($res, $res2, $res3);?>
    plot1 = $.jqplot('chart', [s1, s2], {
      seriesDefaults:{
        renderer:$.jqplot.BarRenderer,
        rendererOptions: {fillToZero: true},
		pointLabels: {show: true}
      },
	  title: 'آمـار فـروش بـرای › <?php echo $core->year;?>',
      series:[
        {label:'فـروش کـل'},
        {label:'درآمـد کـل'}
      ],
      legend: {
        show: true,
		placement:'outsideGrid',
		location: 'ne'
      },
      axes: {
        xaxis: {
          renderer: $.jqplot.CategoryAxisRenderer,
          ticks: ticks
        },
        yaxis: {
			tickOptions:{
            formatString:'$%.2f'
            },
          autoscale: false
        }
      }
    });
  });
</script>
<?php endif;?>
<?php if($reports == 0):?>
<?php echo $core->msgAlert('<span>! تـوجـه</span>...برای سال انتخاب شده هیچ فروشی وجود ندارد',false);?>
<?php else:?>
<div id="chart"></div>
<table cellpadding="0" cellspacing="0" class="display">
  <thead>
    <tr>
      <th width="150" nowrap="nowrap">سـال / مـاه</th>
      <th>تعـداد فـروش هـا</th>
      <th width="200" nowrap="nowrap">درآمـد کـل</th>
    </tr>
  </thead>
  <?php foreach($reports as $report):?>
  <tr>
    <td align="center"><?php echo date("M", mktime(0, 0, 0, $report['month'], 10));?> / <?php echo $core->year;?></td>
    <td align="center"><?php echo $report['total'];?></td>
    <td align="center"><?php echo $core->formatMoney($report['totalprice']);?></td>
  </tr>
  <?php endforeach ?>
  <?php unset($report);?>
  <tr>
    <td align="center"><strong>تعـداد سـال</strong></td>
    <td align="center"><strong><?php echo $row['total'];?></strong></td>
    <td align="center"><strong><?php echo $core->formatMoney($row['totalprice']);?></strong></td>
  </tr>
</table>
<?php endif;?>
<div class="box" style="margin-top:10px">
  <form method="get" action="" name="date">
    <table cellpadding="0" cellspacing="0" class="utility">
      <tr>
        <td class="right"><select name="year" class="select" style="width:80px">
            <?php echo $core->yearList(2010, strftime('%Y')); ?>
          </select>
          <input name="submit" value="ثبـت کـردن" type="submit" class="button-alt-sml"/>
          <input name="do" type="hidden" value="تـراکنـش هـا" />
          <input name="action" type="hidden" value="فـروش سـال" /></td>
      </tr>
    </table>
  </form>
</div>
<?php break;?>
<?php case "edit":?>
<?php $row = $item->getTransactionRecord();?>
<h1><img src="images/trans-lrg.png" alt="" />مـدیـریـت پـرداخـت تـراکنـش هـا</h1>
<p class="info">. در اینجا شما می توانید بصورت دستی وضعیت تراکنش ها را بروز نمائید
<br/> . برای دانلـود، به ازای پرداخت می بایست وضعیت پرداخت تکمیل و وضعیت تراکنش فعال باشد  
<br/> . همچنین شما می توانید تعداد دانلودهای در حال پردازش را مجددا تنظیم نمائید 
<br/> ! با صفر کردن تعداد دانلـودها، شمارنده مذکور مجددا بر اساس تعداد دانلـود و یا روز شروع خواهد شد، البته در این حالت شما قادر به برگرداندن آن زمان نخواهید بود  
<!--Here you can manually update transaction status. In order for download to be valid both Payment Status/Transaction Status must be Completed/Active. 
You can aslo reset number of already processed downloads.<br />
Reseting to 0 will start counter again unless your product downloads are based on number of days. In this case you will not be able to revert the time.--></p>
<?php if($row ):?>
<form action="" method="post" id="admin_form" name="admin_form">
  <table cellpadding="0" cellspacing="0" class="forms">
    <thead>
      <tr>
        <th colspan="2" class="right">در حـال ویـرایـش رکـورد تـراکنـش &rsaquo; <?php echo $row['title'];?></th>
      </tr>
    </thead>
    <tfoot>
      <tr>
        <td align="left"><input type="submit" name="submit" class="button" value="بـروز رسـانـی تـراکنـش" /></td>
        <td><a href="index.php?do=transactions" class="button-alt">انصـراف</a></td>
      </tr>
    </tfoot>
    <tbody>
      <tr>
        <th width="200"><strong>تـاریـخ تـراکنـش</strong>: </th>
        <td><?php echo $row['cdate'];?></td>
      </tr>
      <tr>
        <th>نـام کـاربـری : </th>
        <td><?php echo $row['username'];?></td>
      </tr>
      <tr>
        <th>نـام محصـول :</th>
        <td><?php echo $row['title'];?></td>
      </tr>
      <tr>
        <th>ایمیـل خریـدار : </th>
        <td><?php echo $row['payer_email'];?></td>
      </tr>
      <tr>
        <th>قیمـت : </th>
        <td><?php echo $core->formatMoney($row['price']);?></td>
      </tr>
      <tr>
        <th>پـول رایـج : </th>
        <td><?php echo $row['currency'];?></td>
      </tr>
      <tr>
        <th>روش پـرداخـت : </th>
        <td><?php echo $row['pp'];?></td>
      </tr>
      <tr>
        <th><strong>یـادادشـت تـراکنـش</strong>:</th>
        <td><textarea name="memo" rows="3" cols="40"><?php echo $row['memo'];?></textarea></td>
      </tr>
      <tr>
        <th>تعـداد دانلـودهـا :</th>
        <td><input name="downloads" type="text"  class="inputbox" value="<?php echo $row['downloads'];?>" size="5"  /></td>
      </tr>
      <tr>
        <th>وضعیـت پـرداخـت :</th>
        <td><select name="status" class="select" style="width:150px">
              <option value="1"<?php if($row['status'] == 1) echo ' selected="selected"';?>>تکمیـل شـده</option>
              <option value="0"<?php if($row['status'] == 0) echo ' selected="selected"';?>>در انتـظار</option>
          </select></td>
      </tr>
      <tr>
        <th>وضعـیت تـراکنـش :</th>
        <td><select name="active" class="select" style="width:150px">
              <option value="1"<?php if($row['active'] == 1) echo ' selected="selected"';?>>فعـال</option>
              <option value="0"<?php if($row['active'] == 0) echo ' selected="selected"';?>>غیـر فعـال</option>
          </select></td>
      </tr>
    </tbody>
  </table>
  <input name="id" type="hidden" value="<?php echo $core->id;?>" />
</form>
<?php echo $core->doForm("processTransaction");?> 
<?php endif;?>
<?php break;?>
<?php case "add":?>
<?php $prodrow = $item->getProductList();?>
<?php $gaterow = $content->getGateways(true);;?>
<h1><img src="images/trans-lrg.png" alt="" />مـدیـریـت پـرداخـت تـراکنـش هـا</h1>
<p class="info">. در اینجا شما می توانید بصورت دستی پرداخت تراکنـش ها را مشخص کنید، موارد ضروری با <?php echo required();?> مشخص شده اند </p>
<form action="" method="post" id="admin_form" name="admin_form">
  <table cellpadding="0" cellspacing="0" class="forms">
    <thead>
      <tr>
        <th colspan="2" class="right">&nbsp;اضـافـه کـردن رکـورد تـراکنـش</th>
      </tr>
    </thead>
    <tfoot>
      <tr>
        <td align="left"><input type="submit" name="submit" class="button" value="اضـافـه کـردن رکـورد" /></td>
        <td><a href="index.php?do=transactions" class="button-alt">انصـراف</a></td>
      </tr>
    </tfoot>
    <tbody>
      <tr>
        <th width="200"><strong>تـاریـخ تـراکنـش</strong>: <?php echo required();?></th>
        <td><input name="created" type="text" class="inputbox" id="date" value="<?php echo date('Y-m-d');?>" size="25" /></td>
      </tr>
      <tr>
        <th>نـام کـاربـری : <?php echo required();?></th>
        <td><div id="table-search" style="display: none;">
            <div style="margin-bottom:5px">جستجو و انتخاب مشتری برای این تراکنـش</div>
            <div style="margin-bottom:5px">
              <input type="text" name="search" id="search_box" class="inputbox" size="25" onclick="disAutoComplete(this);"/>
            </div>
            <div style="margin-bottom:5px">
              <a href="javascript:void(0);" id="search_button" class="button-alt-sml">جستجـو</a>
              <a href="javascript:void(0);" id="reset-btn" onclick="resetAccount();" class="button-alt-sml">باز نشاندن</a>
              <a href="javascript:void(0);" id="cancel-btn" onclick="cancelAccount();" class="button-alt-sml">انصراف</a>
            </div>
            <div id="accounts-result"></div>
          </div>
          <div id="table-accounts"><span id="selected-account"> <a href="javascript:changeAccount()"><strong>برای انتخاب کـاربـر کلیک کنید..</strong></a> </span> <span id="user_temp">
            </span></div></td>
      </tr>
      <tr>
        <th>روش پـرداخـت :</th>
        <td>
          <select name="pp" class="select" style="width:200px">
        <?php if($gaterow):?>
            <?php foreach ($gaterow as $grow) : ?>
              <option value="<?php echo $grow['displayname'];?>"><?php echo $grow['displayname'];?></option>
            <?php endforeach; ?>
         <?php endif; ?>
          </select>
          </td>
      </tr>
      <tr>
        <th>تعـداد : </th>
        <td><input name="item_qty" type="text"  class="inputbox" value="1" size="5"  /></td>
      </tr>
      <tr>
        <th>انتخـاب محصـول : <?php echo required();?></th>
        <td><div class="scrollbox">
        <?php if($prodrow):?>
            <?php $class = 'odd'; ?>
            <?php foreach ($prodrow as $prow) : ?>
            <?php $class = ($class == 'even' ? 'odd' : 'even'); ?>
            <div class="<?php echo $class; ?>">
              <input type="radio" name="pid" value="<?php echo $prow['id']; ?>" />
              <?php echo $prow['title'];?></div>
            <?php endforeach; ?>
         <?php endif; ?>
        </div></td>
      </tr>
      <tr>
        <th><strong>یـادداشـت تـراکنـش</strong>:</th>
        <td><textarea name="memo" rows="3" cols="43"></textarea></td>
      </tr>
      <tr>
        <th>اعـلام به کاربـر :</th>
        <td><input type="checkbox" name="notify" class="checkbox" value="1" />
        <?php echo tooltip(". برای اطلاع به کاربر از فرایند این تراکنش، یک ایمیل ارسال خواهد شد");?></td>
      </tr>
    </tbody>
  </table>
</form>
<?php echo $core->doForm("processTransaction");?> 
<script type="text/javascript"> 
// <![CDATA[
$(function () {
    $("#date").datepicker({
        showOn: 'button',
        buttonImage: 'images/calendar.png',
        buttonImageOnly: true,
        dateFormat: 'yy-mm-dd'
    });
});
$(function () {
    $("#search_button").click(function () {
        var search_word = $("#search_box").val();
        var dataString = 'getusername=' + search_word;
        if (search_word != '') {
            $.ajax({
                type: "POST",
                url: "controller.php",
                data: dataString,
                cache: false,
                beforeSend: function (html) {
                    $("#loader").show();
                    $("#searchword").show();
                    $(".searchword").html(search_word);
                },
                success: function (html) {
                    $("#accounts-result").show();
                    $("#accounts-result").append(html);
                    $("#loader").hide();

                }
            });
        }
        return false;
    });
});

function getAccount(userinfo) {
    var info = new Array();
    info = userinfo.split(":");

    $('#selected-account').html("<a style='vertical-align: middle' href='javascript:changeAccount()'>" + info[1] + "<\/a>");
	$('#user_temp').remove();
    $('#selected-account').append("<input type='hidden' id='user_id' name='uid' value='" + info[0] + "' \/>");
	$("#table-search").css("display", "none");
	$("#table-accounts").css("display", "block");
}

function resetAccount() {
	var msg = '';
	$("#search_box").val(msg);
	$("#accounts-result").css("display", "none");
}

function changeAccount() {
	resetAccount();
	$("#table-search").css("display", "block"); 
	$("#table-accounts").css("display", "none");
}
function cancelAccount() {
	$("#table-search").css("display", "none");
	$("#table-accounts").css("display", "block");
}
// ]]>
</script>
<?php break;?>
<?php default: ?>
<?php
  $search = (isset($_POST['search'])) ? intval($_POST['search']) : false;
  $transrow = $item->getPayments($search);
?>
<h1><img src="images/trans-lrg.png" alt="" />مـدیـریـت پـرداخـت تـراکنـش هـا</h1>
<p class="info">. در اینجا شما می توانید تمام تراکنش ها را مشاهده نمائید<br />
<strong>. توجه : با حذف یک تراکنش، دسترسی دانلود برای محصول خریداری شده را نیز حذف می نمائیـد</strong></p>
<h2><span> &nbsp;&nbsp;<a href="controller.php?exportTransactions" title="Excel خروجی گرفتن با فرمت" class="tooltip"><img src="images/xls.png" alt="" class="img-wrap2"/></a> <a href="index.php?do=transactions&amp;action=salesyear" title="مـشـاهـده گـزارش فـروش" class="tooltip"><img src="images/chart.png" alt="" class="img-wrap2"/></a> &nbsp;&nbsp;<a href="index.php?do=transactions&amp;action=add" class="button-alt-sml">اضـافـه کـردن رکـورد پـرداخـت</a></span>مـشـاهـده تـراکنـش هـا&nbsp;</h2>
<div class="box" style="margin-bottom:10px">
  <table cellpadding="0" cellspacing="0" class="utility">
    <tr>
      <td><form action="" method="post">&nbsp;&nbsp;&nbsp;
          <input name="search" type="text" class="inputbox" id="search-input" size="31"/>
          <input name="submit" type="submit" class="button-alt-sml" value="پیدا کردن" />
        </form></td>
      <td align="center"><form action="" method="get" name="filter_browse" id="filter_browse">
          <strong>فیلتر پرداخت ها :</strong>&nbsp;&nbsp;
          <select name="select" class="select" onchange="if(this.value!='NA') window.location = 'index.php?do=transactions&amp;sort='+this[this.selectedIndex].value; else window.location = 'index.php?do=transactions';" style="width:210px">
            <option value="NA">-- بازنشاندن فیلتر پرداخت ها --</option>
            <?php echo $item->getPaymentFilter();?>
          </select>
        </form></td>
    </tr>
    <tr>
      <td class="border"><form action="" method="post" id="dForm">
          <strong> از </strong>
          <input name="fromdate" type="text" style="margin-right:3px" class="inputbox" size="10" id="fromdate" />
          <strong> بـه </strong>
          <input name="enddate" type="text" style="margin-right:3px" class="inputbox" size="10" id="enddate" />
          <input name="find" type="submit" class="button-alt-sml" value="پیدا کردن" />
        </form></td>
      <td align="center" class="border"><?php echo $pg->items_per_page();?> &nbsp;&nbsp;
        <?php if($pg->num_pages >= 1) echo $pg->jump_menu();?></td>
    </tr>
  </table>
</div>
<table cellpadding="0" cellspacing="0" class="display">
  <thead>
    <tr>
      <th width="20">#</th>
      <th class="right">نام محصول</th>
      <th class="right">نام کاربری</th>
      <th class="right">مبلغ</th>
      <th class="right">تاریخ پرداخت</th>
      <th>پردازش</th>
      <th>وضعیت</th>
      <th>ویرایش</th>
      <th>حذف</th>
    </tr>
  </thead>
  <tbody>
    <?php if($transrow == 0):?>
    <tr>
      <td colspan="9"><?php echo $core->msgAlert('<span>! هشدار</span>...شما هنوز تراکنشی نداشته اید',false);?></td>
    </tr>
    <?php else:?>
    <?php foreach ($transrow as $row):?>
    <?php $image = ($row['status'] == 0) ? " در انتظار ":" تکمیل شده ";?>
    <?php $status = ($row['status'] == 0) ? 1:0;?>
    <tr>
      <th><?php echo $row['id'];?>.</th>
      <td><a href="index.php?do=products&amp;action=edit&amp;pid=<?php echo $row['pid'];?>"><?php echo $row['title'];?></a></td>
      <td><a href="index.php?do=users&amp;action=edit&amp;userid=<?php echo $row['uid'];?>"><?php echo $row['username'];?></a></td>
      <td><?php echo $core->formatMoney($row['price']);?></td>
      <td><?php echo $row['cdate'];?></td>
      <td align="center"><img src="images/<?php echo $row['pp'];?>.png" alt="" class="tooltip" title="<?php echo $row['pp'];?>"/></td>
      <td align="center"><img src="images/<?php echo $image;?>.png" alt="" class="tooltip img-wrap2" title="وضعیت: <?php echo ucfirst($image);?>"/></td>
      <td align="center"><a href="index.php?do=transactions&amp;action=edit&amp;id=<?php echo $row['id'];?>"><img src="images/edit.png" class="tooltip img-wrap2"  alt="" title="ویرایش"/></a></td>
      <td align="center"><a href="javascript:void(0);" class="delete" rel="<?php echo $row['created'];?>" id="item_<?php echo $row['id'];?>"><img src="images/delete.png" class="tooltip img-wrap2"  alt="" title="حذف"/></a></td>
    </tr>
    <?php endforeach;?>
    <?php unset($row);?>
    <?php if($pg->items_total >= $pg->items_per_page):?>
    <tr style="background-color:transparent">
      <td colspan="9"><div class="pagination"><span class="inner"><?php echo $pg->display_pages();?></span></div></td>
    </tr>
    <?php endif;?>
    <?php endif;?>
  </tbody>
</table>
<div id="dialog-confirm" style="display:none;" title="حذف رکورد تراکنش">
  <p style="font-family:tahoma; font-size:13px; text-align:right;">
  <span class="ui-icon ui-icon-alert" style="float:right; margin:5px 2px 10px 7px;"></span>
  آیا از حذف این گزینـه اطمینان دارید ؟<br />
  <strong style="font-family:tahoma; font-size:12px; padding-top:8px; float:left;">!!!
  امکان بازگرداندن وجود ندارد</strong></p>
</div>
<script type="text/javascript"> 
// <![CDATA[
$(document).ready(function () {
	$("#search-input").watermark("مبلغ پرداختی..");
    $('a.delete').live('click', function () {
        var id = $(this).attr('id').replace('item_', '')
        var parent = $(this).parent().parent();
		var title = $(this).attr('rel');
        $("#dialog-confirm").data({
            'delid': id,
            'parent': parent,
			'title': title
        }).dialog('open');
        return false;
    });

    $("#dialog-confirm").dialog({
        resizable: false,
        bgiframe: true,
        autoOpen: false,
        width: 400,
        height: "auto",
        zindex: 9998,
        modal: false,
        buttons: {
            'حـذف': function () {
                var parent = $(this).data('parent');
                var id = $(this).data('delid');
				var title = $(this).data('title');

                $.ajax({
                    type: 'post',
                    url: "controller.php",
                    data: 'deleteTransaction=' + id + '&posttitle=' + title,
                    beforeSend: function () {
                        parent.animate({
                            'backgroundColor': '#FFBFBF'
                        }, 400);
                    },
                    success: function (msg) {
                        parent.fadeOut(400, function () {
                            parent.remove();
                        });
						$("html, body").animate({scrollTop:0}, 600);
						$("#msgholder").html(msg);
                    }
                });

                $(this).dialog('close');
            },
            'انصـراف': function () {
                $(this).dialog('close');
            }
        }
    });
});
$(function() {
	var dates = $('#fromdate, #enddate').datepicker({
		defaultDate: "+1w",
		changeMonth: false,
		numberOfMonths: 2,
		dateFormat: 'yy-mm-dd',
		onSelect: function(selectedDate) {
			var option = this.id == "fromdate" ? "minDate" : "maxDate";
			var instance = $(this).data("datepicker");
			var date = $.datepicker.parseDate(instance.settings.dateFormat || $.datepicker._defaults.dateFormat, selectedDate, instance.settings);
			dates.not(this).datepicker("option", option, date);
		}
	});
});
// ]]>
</script>
<?php break;?>
<?php endswitch;?>